import pandas as pd
from typing import Optional

def read_prestacked(prestack_csv: str, meta_csv: Optional[str]=None):
    df = pd.read_csv(prestack_csv)
    required = ['stack_id','R_G_bin','Mstar_bin','b','gamma_t','weight']
    for c in required:
        if c not in df.columns:
            raise ValueError(f"prestacked_stacks.csv missing column: {c}")
    meta=None
    if meta_csv:
        try: meta = pd.read_csv(meta_csv)
        except Exception: meta=None
    return df, meta

def parse_RG_bin_mid(s: str) -> float:
    s = str(s).replace('–','-').replace('to','-')
    num = ''.join(ch if ch.isdigit() or ch=='.' or ch=='-' else ' ' for ch in s)
    parts = [p for p in num.split() if p]
    vals=[]
    for p in parts:
        try: vals.append(float(p))
        except: pass
    if len(vals)>=2: return 0.5*(vals[0]+vals[1])
    if len(vals)==1: return vals[0]
    return float('nan')
